/**
 * Created by lei.wang_1 on 2016/8/8.
 */
appModule.controller('TaskDetailCtrl', ['$scope', 'utils', 'pages','notices','api', 'log', function ($scope,  utils, pages,notices,api,log) {
    $scope.init = function () {
        var params = window.location.search;
        $scope.detailURL =utils.getUrlParam(params,'detailURL');
        $scope.bbsId = utils.getUrlParam(params,'id');
        $scope.isLink = utils.getUrlParam(params,'link')?true:false;
        if(!$scope.bbsId){
            var detailURL = utils.getUrlParam(params,'detailURL');
            if(detailURL){
                $scope.bbsId = utils.getUrlParam(detailURL,'id');
            }
            if(!$scope.bbsId){
                return;
            }
        }
        api.getOneNotice($scope.bbsId, function (data) {
            utils.applyScope($scope, function () {
                var tempNotice = notices.notice.create();
                notices.notice.convertFromData(tempNotice, data);
                $scope.notice = $.extend($scope.notice, tempNotice);
                //$scope.notice.forceAvatar = utils.retrieveUser().userId == data.user_id;
                if ($scope.notice.commentEnabled) {
                    $scope.showComments = true;
                    $scope.$broadcast('getComments');
                }
            });
        }, function (msg) {
            log.logInfo("failed to load notice " + $scope.bbsId  + "'s detail:" + msg);
        });
    };

    $scope.onScrollDown = function(){
        $scope.$broadcast("onScrollDown");
    };

    $scope.init();

    $scope.onClose = function () {
        $scope.$destroy();
        utils.stopPlayMedia();
        pages.closeWindow();
    };
}]);
